<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'mobile', 'country_code_id', 'password', 'type', 'status', 'admin_approve', 'confirm_code', 'confirmation_status', 'image', 'wallet', 'id_number', 'age', 'verified', 'rank', 'account_type', 'certification_image', 'bank_name', 'bank_image', 'account_number', 'experience', 'currency_id', 'gender', 'completed_register');

    public function tokens()
    {
        return $this->hasMany('DeviceToken', 'user_id');
    }

    public function favourite_services()
    {
        return $this->belongsToMany('Service', 'service_favourites', 'user_id', 'service_id');
    }

    public function guide_rates()
    {
        return $this->belongsToMany('User', 'rates', 'guide_id', 'user_id');
    }

    public function customized_trips()
    {
        return $this->belongsTo('CustomizedTrips', 'client_id');
    }

    public function guides_customized_trips()
    {
        return $this->hasOne('CustomizedTrips', 'guide_id');
    }

    public function notifications()
    {
        return $this->hasMany('Notification', 'user_id');
    }

    public function walletCharges()
    {
        return $this->hasMany('WalletCharge', 'user_id');
    }

}